#include <Adafruit_NeoPixel.h>
#define PIN_WS2812B  2   // The Arduino Nano pin that connects to WS2812B
#define NUM_PIXELS   10  // The number of LEDs (pixels) on WS2812B   
Adafruit_NeoPixel WS2812B(NUM_PIXELS, PIN_WS2812B, NEO_GRB + NEO_KHZ800); 

int velocity = 50; 
int color1[3] = {255,0,0}; 
int color2[3] = {255,255,0};
int color3[3] = {0,255,0}; 

void setup() {
  WS2812B.begin(); // INITIALIZE WS2812B strip object (REQUIRED)
  WS2812B.setBrightness(1);
  Serial.begin(9600);
}

void loop() { 
  modus1(); 
  delay(1000);
  modus2(); 
  delay(1000);
  modus3(); 
  delay(1000);
  modus4(); 
  delay(1000);
}


void modus1 (){ //on and off
  for ( int i = 0; i <= NUM_PIXELS - 1; i++){
    WS2812B.setPixelColor(i, WS2812B.Color(color1[0], color1[1], color1[2]));
    WS2812B.show(); 
    delay(velocity);
  }
  for ( int i = 0; i <= NUM_PIXELS - 1; i++){
    WS2812B.setPixelColor(i, WS2812B.Color(0,0,0)); 
    WS2812B.show(); 
    delay(velocity);
  } 
}

void modus2 (){ //pixel change color  pixel by pixel 3x
   for ( int i = 0; i <= NUM_PIXELS - 1; i++){
    WS2812B.setPixelColor(i, WS2812B.Color(color1[0], color1[1], color1[2]));
    WS2812B.show(); 
    delay(velocity);
  } 
  for ( int i = 0; i <= NUM_PIXELS - 1; i++){
    WS2812B.setPixelColor(i, WS2812B.Color(color2[0], color2[1], color2[2]));
    WS2812B.show(); 
    delay(velocity);
  }
  for ( int i = 0; i <= NUM_PIXELS - 1; i++){
    WS2812B.setPixelColor(i, WS2812B.Color(color3[0], color3[1], color3[2]));
    WS2812B.show(); 
    delay(velocity);
  }
  for ( int i = 0; i <= NUM_PIXELS - 1; i++){
    WS2812B.setPixelColor(i, WS2812B.Color(0,0,0));
    WS2812B.show(); 
    delay(velocity);
  }
} 

void modus3 (){ //on_off to center
   for ( int i = 0; i <= NUM_PIXELS/2-1; i++){
    WS2812B.setPixelColor(i, WS2812B.Color(color1[0], color1[1], color1[2]));
    WS2812B.setPixelColor(NUM_PIXELS-i-1, WS2812B.Color(color1[0], color1[1], color1[2]));

    WS2812B.show(); 
    delay(velocity);delay(velocity);delay(velocity);
  } 
  for ( int i = 0; i <= NUM_PIXELS/2-1; i++){
    WS2812B.setPixelColor(i, WS2812B.Color(0,0,0)); 
    WS2812B.setPixelColor(NUM_PIXELS-i-1, WS2812B.Color(0,0,0));
    WS2812B.show(); 
    delay(velocity);
    delay(velocity);delay(velocity);
  } 
}

void modus4 (){ //Light stacking up from bottom to top
  for ( int j = 0; j <= NUM_PIXELS - 1; j++){
    for ( int i = 0; i <= NUM_PIXELS - 1 -j; i++){
      WS2812B.setPixelColor(i, WS2812B.Color(color1[0], color1[1], color1[2]));
      WS2812B.setPixelColor(i-1, WS2812B.Color(0,0,0));
      WS2812B.show(); 
      delay(velocity);
    }
  }

  delay(1000);
  
  for ( int j = 0; j <= NUM_PIXELS - 1; j++){
    for ( int i = 0; i <= NUM_PIXELS - 1 -j; i++){
      WS2812B.setPixelColor(i, WS2812B.Color(color2[0], color2[1], color2[2]));
      WS2812B.setPixelColor(i-1, WS2812B.Color(0,0,0));
      WS2812B.show(); 
      delay(velocity);
    }
  }

  delay(1000);
  
  for ( int j = 0; j <= NUM_PIXELS - 1; j++){
    for ( int i = 0; i <= NUM_PIXELS - 1 -j; i++){
      WS2812B.setPixelColor(i, WS2812B.Color(color3[0], color3[1], color3[2]));
      WS2812B.setPixelColor(i-1, WS2812B.Color(0,0,0));
      WS2812B.show(); 
      delay(velocity);
    }
  }


} 